Attribute VB_Name = "modDB"
Option Explicit

Public Function GetDBVersion(oDB As ADODB.Connection, _
                Optional sColumnName As String = "nDBVersion", Optional sTableName As String = "DBInfo") As Long

    Dim i As Long
    Dim rstTmp As ADODB.Recordset
    Dim bFound As Boolean
    
    'Now we setup error checking for trying to read the version
    Set rstTmp = OpenMyRecordset(oDB, "SELECT " & sColumnName & " FROM " & sTableName)
    
    bFound = False
    For i = 0 To rstTmp.Fields.Count
        If rstTmp.Fields(i).Name = sColumnName Then
            GetDBVersion = rstTmp![nDBVersion]
            bFound = True
            Exit For
        End If
    Next i
    If bFound = False Then
        Call Err.Raise(-1, "GetDBVersion", "Unable to locate " & sColumnName & " in " & sTableName & ".  Ordinal referance failed.")
    End If

End Function

Public Function OpenDB(sFileName As String) As ADODB.Connection
    
    Dim sConnectionString As String
    Dim rstTmp As ADODB.Recordset
    Dim nUpgradeFrom As Long
    nUpgradeFrom = 1
    Set OpenDB = New ADODB.Connection

    'Ok this gets confusing....  First of all we will try to open the DB as a Jet 3.51 DB.
    On Error GoTo Jet351_Failed
    'Try to open it
    sConnectionString = "Provider=Microsoft.JET.OLEDB.3.51;Data Source=" & sFileName
    Call OpenDB.Open(sConnectionString)
    'We only get to this goto if the open command worked
    GoTo DBOpened
    'Oops, this means we got an error
Jet40:
    'Setup a normal error handler so if an error happens we don't jump back to Jet 4.0
    On Error GoTo 0 'Jet40_Failed
    'Now try to open the DB with Jet 4.0
    sConnectionString = "Provider=Microsoft.JET.OLEDB.4.0;Data Source=" & sFileName
    Call OpenDB.Open(sConnectionString)
    
    'Yea we got the damn db open!
DBOpened:
        
    Exit Function
Jet351_Failed:
    If Err.Number = 3706 Then 'This is the provider not found message.
        GoTo Jet40
    Else
        Call Err.Raise(Err.Number, Err.Source, Err.Description)
    End If

End Function

Public Function OpenMyRecordset(dbDatabase As ADODB.Connection, sSQL As String) As ADODB.Recordset

    Dim oRSetReturn As New ADODB.Recordset

    oRSetReturn.CursorLocation = ADODB.adUseClient
    oRSetReturn.CursorType = ADODB.adOpenKeyset

    oRSetReturn.LockType = ADODB.adLockOptimistic
    Call oRSetReturn.Open(sSQL, dbDatabase, oRSetReturn.CursorType, ADODB.adLockUnspecified, ADODB.adCmdText)
    Set OpenMyRecordset = oRSetReturn

End Function
